/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperRecipe;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.items.crafting.NpcShapedRecipes;
import noppes.npcs.reflection.item.crafting.IngredientReflection;
import noppes.npcs.reflection.item.crafting.ShapelessRecipesReflection;
import noppes.npcs.util.Util;

public class NpcShapelessRecipes
extends ShapelessRecipes
implements INpcRecipe,
IRecipe {
    private ItemStack recipeOutput;
    public NonNullList<Ingredient> field_77579_b;
    public boolean isSimple;
    public Availability availability;
    private boolean global;
    public int id;
    public boolean ignoreDamage;
    public boolean ignoreNBT;
    public boolean known;
    public boolean main = false;
    public String name;
    private int recipeHeight;
    private int recipeWidth;
    public boolean savesRecipe;
    private final WrapperRecipe wrapper = new WrapperRecipe();

    public static INpcRecipe createRecipe(String group, String name, boolean global, ItemStack stack, Object ... map) {
        StringBuilder allRows = new StringBuilder();
        int objPos = 0;
        if (map[objPos] instanceof String[]) {
            String[] var8;
            String[] var7 = var8 = (String[])map[objPos++];
            int var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String row = var8[var10];
                allRows.append(row);
            }
        } else {
            while (map[objPos] instanceof String) {
                String row = (String)map[objPos++];
                allRows.append(row);
            }
        }
        HashMap<Character, ItemStack> mapIngredients = new HashMap<Character, ItemStack>();
        while (objPos < map.length) {
            Character c = (Character)map[objPos];
            ItemStack st = ItemStack.field_190927_a;
            if (map[objPos + 1] instanceof Item) {
                st = new ItemStack((Item)map[objPos + 1]);
            } else if (map[objPos + 1] instanceof Block) {
                st = new ItemStack((Block)map[objPos + 1], 1, -1);
            } else if (map[objPos + 1] instanceof ItemStack) {
                st = (ItemStack)map[objPos + 1];
            }
            mapIngredients.put(c, st);
            objPos += 2;
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        int slot = 0;
        for (int i = 0; i < allRows.length(); ++i) {
            ItemStack s;
            char c = allRows.charAt(i);
            if (!mapIngredients.containsKey(Character.valueOf(c)) || (s = ((ItemStack)mapIngredients.get(Character.valueOf(c))).func_77946_l()).func_190926_b()) continue;
            ingredients.add(slot++, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{s}));
        }
        return new NpcShapelessRecipes(group, name, global, (NonNullList<Ingredient>)ingredients, stack);
    }

    public static NpcShapelessRecipes read(NBTTagCompound compound) {
        NpcShapelessRecipes recipe = new NpcShapelessRecipes(Util.instance.getResourceName(compound.func_74779_i("Group")), Util.instance.getResourceName(compound.func_74779_i("Name")), compound.func_74767_n("Global"), NBTTags.getIngredientList(compound.func_150295_c("Materials", 10)), new ItemStack(compound.func_74775_l("Item")));
        recipe.id = compound.func_74762_e("ID");
        recipe.availability.load(compound.func_74775_l("Availability"));
        recipe.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        recipe.ignoreNBT = compound.func_74767_n("IgnoreNBT");
        recipe.known = compound.func_74767_n("IsKnown");
        recipe.main = compound.func_74767_n("IsMain");
        if (recipe.getRegistryName() == null) {
            String key = recipe.getNpcGroup().toLowerCase() + "_" + recipe.name.toLowerCase();
            while (key.contains(" ")) {
                key = key.replace(" ", "_");
            }
            recipe.setRegistryName(new ResourceLocation("customnpcs", key));
        }
        return recipe;
    }

    public NpcShapelessRecipes(String group, String name, boolean isGlobal, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(Util.instance.getResourceName(group), result, ingredients);
        if (result.func_190926_b()) {
            result = new ItemStack(Blocks.field_150347_e);
        }
        this.recipeOutput = result;
        if (ingredients.isEmpty()) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150347_e)}));
        }
        this.field_77579_b = ingredients;
        boolean simple = true;
        for (Ingredient i : ingredients) {
            simple &= i.isSimple();
        }
        this.isSimple = simple;
        this.id = -1;
        this.name = Util.instance.getResourceName(name);
        this.availability = new Availability();
        this.global = isGlobal;
        this.ignoreDamage = false;
        this.ignoreNBT = false;
        this.savesRecipe = true;
        this.known = true;
        this.recipeWidth = isGlobal ? 3 : 4;
        int n = this.recipeHeight = isGlobal ? 3 : 4;
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
    }

    private NonNullList<Ingredient> getGrid() {
        NonNullList newIngredient = NonNullList.func_191196_a();
        for (Ingredient ingredient : this.field_77579_b) {
            if (ingredient.func_193365_a().length == 0) continue;
            boolean added = false;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (NoppesUtilServer.IsItemStackNull(stack)) continue;
                added = true;
                break;
            }
            if (!added) continue;
            newIngredient.add((Object)ingredient);
        }
        return newIngredient;
    }

    public boolean apply(@Nullable Ingredient ingredient, @Nullable ItemStack stack) {
        if (stack != null && ingredient != null) {
            ItemStack[] stacks = ingredient.func_193365_a();
            if (stacks.length == 0 && stack.func_190926_b()) {
                return true;
            }
            for (ItemStack ingStack : stacks) {
                if (ingStack.func_77973_b() != stack.func_77973_b() || ingStack.func_190926_b() || stack.func_190926_b() || !NoppesUtilPlayer.compareItems(stack, ingStack, this.ignoreDamage, this.ignoreNBT) || ingStack.func_190916_E() > stack.func_190916_E()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_194133_a(int width, int height) {
        if (!(this.global || width == 4 && height == 4)) {
            return false;
        }
        return width * height >= this.getGrid().size();
    }

    @Override
    public void copy(INpcRecipe recipe) {
        int w;
        NonNullList<Ingredient> ingredients;
        if (recipe == null || this == recipe) {
            return;
        }
        this.id = recipe.getId();
        this.name = recipe.getName();
        this.availability = (Availability)recipe.getAvailability();
        this.global = recipe.isGlobal();
        this.ignoreDamage = recipe.getIgnoreDamage();
        this.ignoreNBT = recipe.getIgnoreNBT();
        this.recipeOutput = recipe.getProduct().getMCItemStack();
        NonNullList<Ingredient> nonNullList = ingredients = recipe instanceof NpcShapelessRecipes ? ((NpcShapelessRecipes)recipe).field_77579_b : ((NpcShapedRecipes)recipe).field_77574_d;
        if (this.field_77579_b != ingredients) {
            this.field_77579_b.clear();
            for (Ingredient ing : ingredients) {
                if (ing.func_193365_a().length == 0) {
                    this.field_77579_b.add((Object)Ingredient.field_193370_a);
                    continue;
                }
                this.field_77579_b.add((Object)Ingredient.func_193369_a((ItemStack[])ing.func_193365_a()));
            }
        }
        ShapelessRecipesReflection.setGroup(this, recipe.getNpcGroup());
        this.known = recipe.isKnown();
        this.recipeWidth = recipe.getWidthRecipe();
        this.recipeHeight = recipe.getHeightRecipe();
        int n = w = this.global ? 3 : 4;
        if (this.recipeWidth != w || this.recipeHeight != w) {
            this.recipeWidth = w;
            this.recipeHeight = w;
        }
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
        this.savesRecipe = true;
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean equal(INpcRecipe recipe) {
        return recipe.getClass() == NpcShapelessRecipes.class && recipe.getNpcGroup().equals(this.func_193358_e()) && recipe.getName().equals(this.name) && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)recipe.getProduct().getMCItemStack(), (ItemStack)this.recipeOutput);
    }

    public boolean equals(INpcRecipe recipe) {
        return !recipe.isShaped() && this.id == recipe.getId() && recipe.isGlobal() != this.global && recipe.getName().equals(this.name) && recipe.getNpcGroup().equals(this.func_193358_e());
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Override
    public int getHeightRecipe() {
        return this.recipeHeight;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public boolean getIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Width", this.recipeWidth);
        compound.func_74768_a("Height", this.recipeHeight);
        if (this.recipeOutput != null) {
            compound.func_74782_a("Item", (NBTBase)this.recipeOutput.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Materials", (NBTBase)NBTTags.nbtIngredientList(this.field_77579_b));
        compound.func_74782_a("Availability", (NBTBase)this.availability.save(new NBTTagCompound()));
        compound.func_74778_a("Name", this.name);
        compound.func_74757_a("Global", this.global);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        compound.func_74778_a("Group", this.func_193358_e());
        compound.func_74757_a("IsKnown", this.known);
        compound.func_74757_a("IsShaped", false);
        compound.func_74757_a("IsMain", this.main);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(compound);
    }

    @Override
    public String getNpcGroup() {
        return this.func_193358_e();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Override
    public IItemStack getProduct() {
        return (IItemStack)this.func_77571_b().getCapability(ItemStackWrapper.ITEM_SCRIPTED_DATA_CAPABILITY, null);
    }

    @Override
    public IItemStack[][] getRecipe() {
        IItemStack[][] allStacks = new IItemStack[this.field_77579_b.size()][];
        for (int i = 0; i < this.field_77579_b.size(); ++i) {
            ItemStack[] arr = ((Ingredient)this.field_77579_b.get(i)).func_193365_a();
            allStacks[i] = new IItemStack[arr.length];
            for (int j = 0; j < arr.length; ++j) {
                allStacks[i][j] = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(arr[j]);
            }
        }
        return allStacks;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        NonNullList list = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            list.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return list;
    }

    @Override
    public int getWidthRecipe() {
        return this.recipeWidth;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean isKnown() {
        return this.known;
    }

    @Override
    public boolean isShaped() {
        return false;
    }

    @Override
    public boolean isValid() {
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
        if (this.func_193358_e().isEmpty()) {
            return false;
        }
        if (this.name == null || this.name.isEmpty()) {
            return false;
        }
        if (this.field_77579_b.isEmpty() || this.recipeOutput.func_190926_b()) {
            return false;
        }
        for (Ingredient ing : this.field_77579_b) {
            if (ing.func_193365_a().length == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRecipeItemsEmpty() {
        for (Ingredient ingredient : this.field_77579_b) {
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (stack == null || stack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public WrapperRecipe getWrapperRecipe() {
        this.wrapper.parent = this;
        this.wrapper.isShaped = false;
        this.wrapper.global = this.global;
        this.wrapper.known = this.known;
        this.wrapper.ignoreDamage = this.ignoreDamage;
        this.wrapper.ignoreNBT = this.ignoreNBT;
        this.wrapper.id = this.id;
        this.wrapper.width = this.recipeWidth;
        this.wrapper.height = this.recipeHeight;
        this.wrapper.group = this.func_193358_e();
        this.wrapper.domen = "customnpcs";
        this.wrapper.name = (this.main ? "\u00a7b" : "") + this.name;
        this.wrapper.product = this.recipeOutput.func_77946_l();
        this.wrapper.availability.load(this.availability.save(new NBTTagCompound()));
        this.wrapper.main = this.main;
        this.wrapper.recipeItems.clear();
        int pos = 0;
        for (Ingredient ingr : this.field_77579_b) {
            ItemStack[] rawMatchingStacks = IngredientReflection.getRawMatchingStacks(ingr);
            ItemStack[] array = new ItemStack[rawMatchingStacks.length];
            for (int j = 0; j < rawMatchingStacks.length; ++j) {
                array[j] = rawMatchingStacks[j].func_77946_l();
            }
            this.wrapper.recipeItems.put(pos, array);
            ++pos;
        }
        return this.wrapper;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public boolean isChanged() {
        return this.savesRecipe;
    }

    @Override
    public void setRecipeOutput(ItemStack cms) {
        if (cms == null || cms.func_190926_b()) {
            return;
        }
        this.recipeOutput = cms.func_77946_l();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nullable World worldIn) {
        int j;
        int i;
        if (this.field_77579_b.isEmpty()) {
            return false;
        }
        if (this.global && inv.func_174923_h() > 3 && inv.func_174923_h() > 3) {
            return false;
        }
        if (!this.global && inv.func_174922_i() == 4 && inv.func_174923_h() == 4) {
            return false;
        }
        ArrayList<Ingredient> ings = new ArrayList<Ingredient>();
        for (Ingredient ingredient : this.field_77579_b) {
            if (ingredient.func_193365_a().length == 0) continue;
            boolean isEmpty = true;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (stack.func_190926_b()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) continue;
            ings.add(ingredient);
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (i = 0; i < inv.func_174923_h(); ++i) {
            for (j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i);
                if (itemstack.func_190926_b()) continue;
                inputs.add(itemstack);
            }
        }
        if (inputs.size() < ings.size()) {
            return false;
        }
        for (i = 0; i < ings.size(); ++i) {
            for (j = 0; j < inputs.size(); ++j) {
                if (!this.apply((Ingredient)ings.get(i), (ItemStack)inputs.get(j))) continue;
                ings.remove(ings.get(i));
                inputs.remove(inputs.get(j));
                i = -1;
                break;
            }
            if (ings.isEmpty() || inputs.isEmpty()) break;
        }
        return ings.isEmpty() && inputs.isEmpty();
    }

    @Override
    public void setIgnoreDamage(boolean bo) {
        this.ignoreDamage = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setIgnoreNBT(boolean bo) {
        this.ignoreNBT = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setKnown(boolean bo) {
        this.known = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setNbt(INbt nbt) {
        this.copy(NpcShapedRecipes.read(nbt.getMCNBT()));
    }
}

